// ====== Application Constants ======

// API Endpoints
export const API_ENDPOINTS = {
    AUTH: {
        LOGIN: '/api/auth/login',
        REGISTER: '/api/auth/register',
        LOGOUT: '/api/auth/logout',
        VERIFY: '/api/auth/verify'
    },
    LEADS: {
        LIST: '/api/leads',
        CREATE: '/api/leads',
        UPDATE: '/api/leads/:id',
        DELETE: '/api/leads/:id'
    },
    USERS: {
        PROFILE: '/api/users/profile',
        UPDATE: '/api/users/update'
    }
};

// App Settings
export const APP_CONFIG = {
    APP_NAME: 'LeadIntelligence AI',
    VERSION: '1.0.0',
    BASE_URL: '/lead-management/public',
    API_TIMEOUT: 10000,
    MAX_FILE_SIZE: 5 * 1024 * 1024, // 5MB
    SUPPORTED_IMAGE_TYPES: ['image/jpeg', 'image/png', 'image/gif']
};

// Local Storage Keys
export const STORAGE_KEYS = {
    AUTH_TOKEN: 'auth_token',
    USER_DATA: 'user_data',
    THEME_PREFERENCE: 'theme_preference',
    LANGUAGE: 'language'
};

// Validation Rules
export const VALIDATION_RULES = {
    EMAIL: /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
    PASSWORD: {
        MIN_LENGTH: 8,
        REQUIRE_UPPERCASE: true,
        REQUIRE_LOWERCASE: true,
        REQUIRE_NUMBER: true,
        REQUIRE_SPECIAL: true
    },
    PHONE: /^\+?[\d\s\-\(\)]{10,}$/,
    NAME: /^[a-zA-ZÀ-ÿ\s'-]{2,50}$/
};

// Error Messages
export const ERROR_MESSAGES = {
    NETWORK_ERROR: 'Network error. Please check your connection.',
    SERVER_ERROR: 'Server error. Please try again later.',
    VALIDATION_ERROR: 'Please check your input and try again.',
    AUTH_ERROR: 'Authentication failed. Please log in again.',
    PERMISSION_ERROR: 'You do not have permission to perform this action.'
};