// Airunner JavaScript - Enhanced Exit Intent
console.log('Airunner loaded successfully!');

// Enhanced Exit-Intent Popup
let exitPopupShown = false;

document.addEventListener('mouseleave', function(e) {
    if (e.clientY < 0 && !exitPopupShown) {
        showExitOffer();
        exitPopupShown = true;
    }
});

function showExitOffer() {
    if (document.getElementById('exit-popup')) return;
    
    const popup = document.createElement('div');
    popup.id = 'exit-popup';
    popup.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 10000; display: flex; align-items: center; justify-content: center; padding: 20px;">
            <div style="background: white; padding: 2rem; border-radius: 12px; max-width: 400px; width: 90%; text-align: center; position: relative;">
                <button onclick="closeExitPopup()" style="position: absolute; top: 10px; right: 10px; background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #666;">×</button>
                
                <div style="margin-bottom: 1rem;">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ffb703, #f97316); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 1.5rem;">🎁</div>
                    <h3 style="margin: 0 0 0.5rem; color: #1f2937;">Wait! Special Offer</h3>
                    <p style="color: #6b7280; margin: 0 0 1.5rem;">Get 30% off your first 3 months when you start today.</p>
                </div>
                
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                    <button onclick="claimDiscount()" style="background: linear-gradient(135deg, #ffb703, #f97316); color: white; border: none; padding: 0.75rem 1.5rem; border-radius: 8px; font-weight: 600; cursor: pointer; transition: transform 0.2s;">
                        Claim My 30% Discount
                    </button>
                    <button onclick="closeExitPopup()" style="background: transparent; color: #6b7280; border: 1px solid #d1d5db; padding: 0.75rem 1.5rem; border-radius: 8px; cursor: pointer;">
                        No thanks, I'll pay full price
                    </button>
                </div>
                
                <div style="margin-top: 1rem; font-size: 0.8rem; color: #9ca3af;">
                    Limited time offer • No credit card required
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(popup);
    document.addEventListener('keydown', handleEscapeKey);
}

function closeExitPopup() {
    const popup = document.getElementById('exit-popup');
    if (popup) {
        popup.remove();
        document.removeEventListener('keydown', handleEscapeKey);
    }
}

function handleEscapeKey(e) {
    if (e.key === 'Escape') closeExitPopup();
}

function claimDiscount() {
    const formSection = document.getElementById('get-started');
    if (formSection) formSection.scrollIntoView({ behavior: 'smooth' });
    
    const form = document.getElementById('leadForm');
    if (form) {
        const discountNote = document.createElement('div');
        discountNote.innerHTML = `
            <div style="background: linear-gradient(135deg, #dcfce7, #bbf7d0); border: 1px solid #22c55e; padding: 0.75rem; border-radius: 8px; margin-bottom: 1rem; text-align: center;">
                <strong style="color: #166534;">🎉 30% Discount Applied!</strong>
                <div style="font-size: 0.9rem; color: #166534; margin-top: 0.25rem;">
                    Your first 3 months will be 30% off
                </div>
            </div>
        `;
        form.insertBefore(discountNote, form.firstChild);
        sessionStorage.setItem('airunner_discount', '30percent');
    }
    closeExitPopup();
}