<?php
namespace App\Models;

class Lead {
    public $id;
    public $form_id;
    public $data;
    public $score;
    public $insights;
    public $created_at;
    
    public function __construct($data = []) {
        $this->id = $data['id'] ?? null;
        $this->form_id = $data['form_id'] ?? null;
        $this->data = isset($data['data']) ? json_decode($data['data'], true) : [];
        $this->score = $data['score'] ?? 0;
        $this->insights = $data['insights'] ?? '';
        $this->created_at = $data['created_at'] ?? date('Y-m-d H:i:s');
    }
    
    public function getField($name) {
        return $this->data[$name] ?? null;
    }
    
    public function getEmail() {
        return $this->getField('email') ?? $this->getField('contact_email');
    }
    
    public function getName() {
        return $this->getField('name') ?? $this->getField('full_name') ?? 'Unknown';
    }
}