<?php
// Expected: $form from FormsController@edit($id)
if (!isset($form)) { $form = []; }
$id          = $form['id'] ?? null;
$name        = $form['name'] ?? $form['title'] ?? '';
$status      = $form['status'] ?? 'draft';
$description = $form['description'] ?? '';
$thankYou    = $form['thank_you_message'] ?? '';
?>
<div class="dashboard-container">
    <section class="form-card">
        <header class="page-header" style="margin-bottom: 1.25rem;">
            <div>
                <div class="page-header-title">
                    Edit Form <?= htmlspecialchars($name ?: '#'.$id) ?>
                </div>
                <div class="page-header-subtitle">
                    Update form settings and messaging.
                </div>
            </div>
        </header>

        <form action="/lead-management/public/app/forms/<?= (int)$id ?>/edit" method="POST">
            <div class="form-grid">
                <div class="form-field">
                    <label for="name">Form Name</label>
                    <input id="name" name="name" type="text"
                           value="<?= htmlspecialchars($name) ?>" required>
                </div>

                <div class="form-field">
                    <label for="status">Status</label>
                    <select id="status" name="status">
                        <?php
                        $statuses = ['draft' => 'Draft', 'open' => 'Open', 'closed' => 'Closed'];
                        foreach ($statuses as $value => $label):
                        ?>
                            <option value="<?= $value ?>" <?= $status === $value ? 'selected' : '' ?>>
                                <?= $label ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-field" style="grid-column:1/-1;">
                    <label for="description">Description</label>
                    <textarea id="description" name="description" rows="3"><?= htmlspecialchars($description) ?></textarea>
                </div>

                <div class="form-field" style="grid-column:1/-1;">
                    <label for="thank_you_message">Thank You Message</label>
                    <textarea id="thank_you_message" name="thank_you_message"
                              rows="3"><?= htmlspecialchars($thankYou) ?></textarea>
                </div>
            </div>

            <div class="form-actions">
                <button type="button" class="btn-secondary"
                        onclick="window.location.href='/lead-management/public/app/forms'">
                    Cancel
                </button>
                <button type="submit" class="btn-primary">
                    Update Form
                </button>
            </div>
        </form>
    </section>
</div>
