<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($pageTitle ?? 'LeadIntelligence AI') ?></title>
    <link rel="stylesheet" href="/lead-management/public/assets/css/main.css">
</head>

<body>
    <!-- Use the header you provided for landing/auth pages -->
    <header class="bg-gray-50 shadow-sm border-b border-gray-200 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-4">
                <!-- Logo and Brand -->
                <div class="flex items-center">
                    <a href="/lead-management/public/" class="flex items-center space-x-3">

                        <span class="text-xl font-bold text-gray-900">LeadIntelligence AI</span>
                    </a>
                </div>

                <!-- Navigation Links -->
                <nav class="hidden md:flex items-center space-x-8">
                    <a href="/lead-management/public/#features" class="text-gray-700 hover:text-indigo-600 font-medium transition duration-150">
                        Features
                    </a>
                    <a href="/lead-management/public/#pricing" class="text-gray-700 hover:text-indigo-600 font-medium transition duration-150">
                        Pricing
                    </a>
                    <a href="/lead-management/public/#about" class="text-gray-700 hover:text-indigo-600 font-medium transition duration-150">
                        About
                    </a>
                    <a href="#" class="text-gray-700 hover:text-indigo-600 font-medium transition duration-150">
                        Documentation
                    </a>
                </nav>

                <!-- Auth Actions -->
                <div class="flex items-center space-x-4">
                    <?php
                    // Check if user is logged in
                    $isLoggedIn = isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
                    ?>

                    <?php if ($isLoggedIn): ?>
                        <!-- User is logged in -->
                        <span class="text-gray-700 text-sm">
                            Welcome, <?= htmlspecialchars($_SESSION['user_name'] ?? 'User') ?>
                        </span>
                        <a href="/lead-management/public/app"
                            class="bg-indigo-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-indigo-700 transition duration-150">
                            Dashboard
                        </a>
                        <a href="/lead-management/public/logout"
                            class="text-gray-700 hover:text-indigo-600 text-sm font-medium transition duration-150">
                            Logout
                        </a>
                    <?php else: ?>
                        <!-- User is not logged in -->
                        <a href="/lead-management/public/login"
                            class="text-gray-700 hover:text-indigo-600 font-medium transition duration-150">
                            Sign In
                        </a>
                        <a href="/lead-management/public/register"
                            class="bg-indigo-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-indigo-700 transition duration-150">
                            Get Started Free
                        </a>
                    <?php endif; ?>
                </div>

                <!-- Mobile menu button -->
                <div class="md:hidden">
                    <button type="button" class="text-gray-700 hover:text-indigo-600 mobile-menu-btn">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Mobile Navigation (hidden by default) -->
            <div class="md:hidden hidden mobile-menu bg-gray-50">
                <div class="px-2 pt-2 pb-3 space-y-1 border-t border-gray-200">
                    <a href="/lead-management/public/#features" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                        Features
                    </a>
                    <a href="/lead-management/public/#pricing" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                        Pricing
                    </a>
                    <a href="/lead-management/public/#about" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                        About
                    </a>
                    <a href="#" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                        Documentation
                    </a>
                    <div class="border-t border-gray-200 pt-4">
                        <?php if ($isLoggedIn): ?>
                            <a href="/lead-management/public/app" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                                Dashboard
                            </a>
                            <a href="/lead-management/public/logout" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                                Logout
                            </a>
                        <?php else: ?>
                            <a href="/lead-management/public/login" class="block px-3 py-2 text-gray-700 hover:text-indigo-600 font-medium">
                                Sign In
                            </a>
                            <a href="/lead-management/public/register" class="block px-3 py-2 text-indigo-600 font-medium">
                                Get Started Free
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main>
        <?= $content ?>
    </main>

    <!-- Footer -->
    <footer class="auth-footer">
        <div class="footer-content">
            <div class="footer-brand">
                <a href="/lead-management/public/" class="footer-logo">
                    <div class="logo-icon">
                        <svg width="24" height="24" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M16 2L20 10L28 12L20 14L16 22L12 14L4 12L12 10L16 2Z" fill="currentColor" />
                            <path d="M6 20L10 24L8 30L16 26L24 30L22 24L26 20L22 18L16 22L10 18L6 20Z" fill="currentColor" />
                        </svg>
                    </div>
                    <span>LeadIntelligence AI</span>
                </a>
                <p class="footer-description">
                    Transform raw leads into revenue with AI-powered lead management.
                </p>
            </div>

            <div class="footer-links">
                <h4>Product</h4>
                <ul>
                    <li><a href="/lead-management/public/#features">Features</a></li>
                    <li><a href="/lead-management/public/#pricing">Pricing</a></li>
                    <li><a href="/lead-management/public/app">Dashboard</a></li>
                </ul>
            </div>

            <div class="footer-links">
                <h4>Support</h4>
                <ul>
                    <li><a href="#">Documentation</a></li>
                    <li><a href="#">Help Center</a></li>
                    <li><a href="#">Contact</a></li>
                </ul>
            </div>
        </div>

        <div class="footer-bottom">
            <p>&copy; 2024 LeadIntelligence AI. All rights reserved.</p>
        </div>
    </footer>

    <script>
        // Mobile menu toggle
        document.addEventListener('DOMContentLoaded', function() {
            const mobileMenuButton = document.querySelector('.mobile-menu-btn');
            const mobileMenu = document.querySelector('.mobile-menu');

            if (mobileMenuButton && mobileMenu) {
                mobileMenuButton.addEventListener('click', function() {
                    mobileMenu.classList.toggle('hidden');
                });
            }
        });
    </script>
</body>

</html>