<!DOCTYPE html>
<html>

<head>
    <title>404 - Page Not Found</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            padding: 50px;
        }

        .error-code {
            font-size: 72px;
            color: #666;
        }

        .error-message {
            font-size: 24px;
            color: #333;
        }

        .debug-info {
            margin-top: 20px;
            padding: 15px;
            background: #f5f5f5;
            border-radius: 5px;
        }
    </style>
</head>

<body>
    <div class="error-code">404</div>
    <div class="error-message">Page Not Found</div>
    <p>The page you are looking for doesn't exist.</p>

    <?php if (isset($_SERVER['REQUEST_URI'])): ?>
        <div class="debug-info">
            <strong>Requested URL:</strong> <?= htmlspecialchars($_SERVER['REQUEST_URI']) ?><br>
            <strong>Try these links:</strong><br>
            <a href="/lead-management/public/">Dashboard</a> |
            <a href="/lead-management/public/forms">Forms</a> |
            <a href="/lead-management/public/leads">Leads</a> |
            <a href="/lead-management/public/ai-tools">AI Tools</a>
        </div>
    <?php endif; ?>
</body>

</html>