<?php include VIEWS_PATH . '/layouts/header.php'; ?>

<div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div>
            <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                Create your account
            </h2>
            <p class="mt-2 text-center text-sm text-gray-600">
                Or <a href="<?= $baseUrl ?? '' ?>/login" class="font-medium text-indigo-600 hover:text-indigo-500">sign in to your existing account</a>
            </p>
        </div>

        <?php if (isset($error)): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                <?= htmlspecialchars($error) ?>
            </div>
        <?php endif; ?>

        <!-- FIXED: Removed duplicate action attribute -->
        <form class="mt-8 space-y-6" action="<?= $baseUrl ?? '' ?>/register" method="post">
            <!-- Account Type -->
            <div>
                <label class="block text-sm font-medium text-gray-700">Account Type</label>
                <div class="mt-2 space-y-2">
                    <label class="inline-flex items-center">
                        <input type="radio" name="account_type" value="individual"
                            <?= ($old['account_type'] ?? 'individual') === 'individual' ? 'checked' : '' ?>
                            class="text-indigo-600 focus:ring-indigo-500">
                        <span class="ml-2">Individual Account</span>
                    </label>
                    <label class="inline-flex items-center">
                        <input type="radio" name="account_type" value="company"
                            <?= ($old['account_type'] ?? '') === 'company' ? 'checked' : '' ?>
                            class="text-indigo-600 focus:ring-indigo-500">
                        <span class="ml-2">Business Account</span>
                    </label>
                </div>
            </div>

            <!-- Name Fields -->
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label for="first_name" class="block text-sm font-medium text-gray-700">First Name</label>
                    <input id="first_name" name="first_name" type="text" required
                        value="<?= htmlspecialchars($old['first_name'] ?? '') ?>"
                        class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                </div>
                <div>
                    <label for="last_name" class="block text-sm font-medium text-gray-700">Last Name</label>
                    <input id="last_name" name="last_name" type="text" required
                        value="<?= htmlspecialchars($old['last_name'] ?? '') ?>"
                        class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                </div>
            </div>

            <!-- Company Field -->
            <div id="company-field" style="display: <?= ($old['account_type'] ?? 'individual') === 'company' ? 'block' : 'none' ?>;">
                <label for="company_name" class="block text-sm font-medium text-gray-700">Company Name</label>
                <input id="company_name" name="company_name" type="text"
                    value="<?= htmlspecialchars($old['company_name'] ?? '') ?>"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <!-- Email -->
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                <input id="email" name="email" type="email" required
                    value="<?= htmlspecialchars($old['email'] ?? '') ?>"
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <!-- Password -->
            <div>
                <label for="password" class="block text-sm font-medium text-gray-700">Password</label>
                <input id="password" name="password" type="password" required
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <div>
                <label for="confirm_password" class="block text-sm font-medium text-gray-700">Confirm Password</label>
                <input id="confirm_password" name="confirm_password" type="password" required
                    class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <!-- Terms -->
            <div class="flex items-center">
                <input id="agree_terms" name="agree_terms" type="checkbox" required
                    class="h-4 w-4 text-indigo-600 focus:ring-indigo-500 border-gray-300 rounded">
                <label for="agree_terms" class="ml-2 block text-sm text-gray-900">
                    I agree to the <a href="<?= $baseUrl ?? '' ?>/terms" class="text-indigo-600 hover:text-indigo-500">Terms of Service</a>
                    and <a href="<?= $baseUrl ?? '' ?>/privacy" class="text-indigo-600 hover:text-indigo-500">Privacy Policy</a>
                </label>
            </div>

            <button type="submit"
                class="group relative w-full flex justify-center py-2 px-4 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                Create Account
            </button>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');

        form.addEventListener('submit', function(e) {
            console.log('Form submitted!');
            console.log('Form action:', form.action);
            console.log('Form method:', form.method);

            // Log all form data
            const formData = new FormData(form);
            for (let [key, value] of formData.entries()) {
                console.log(key + ': ' + value);
            }
        });

        // Company field toggle
        document.querySelectorAll('input[name="account_type"]').forEach(radio => {
            radio.addEventListener('change', function() {
                document.getElementById('company-field').style.display =
                    this.value === 'company' ? 'block' : 'none';
            });
        });
    });
</script>

<?php include VIEWS_PATH . '/layouts/footer.php'; ?>