<?php
class FormsController extends BaseController {
    // Your existing FormsController methods go here
    // They will work exactly as before with minimal changes
    
    public function index() {
        $this->checkAuth();
        
        $stmt = $this->db->prepare("
            SELECT f.*, u.first_name, u.last_name 
            FROM forms f 
            LEFT JOIN users u ON f.user_id = u.id 
            WHERE f.tenant_id = ? 
            ORDER BY f.created_at DESC
        ");
        $stmt->execute([auth_tenant()]);
        $forms = $stmt->fetchAll();
        
        return $this->view->render('pages/forms', [
            'forms' => $forms,
            'currentPage' => 'forms'
        ]);
    }
    
    // Add your other form methods (create, edit, submissions, analytics, etc.)
    // They will work with minimal changes - just replace $this->db with your existing logic
}