<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Airunner • AI-Powered Lead Management</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="/lead-management/public/assets/css/app.css">
    <style>
        /* Enhanced Form States */
        .form-message {
            margin-top: 1rem;
            padding: 0.75rem;
            border-radius: 8px;
            display: none;
            animation: slideDown 0.3s ease-out;
        }

        .form-message.success {
            background: rgba(16, 185, 129, 0.1);
            border: 1px solid rgba(16, 185, 129, 0.3);
            color: #10b981;
        }

        .form-message.error {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #ef4444;
        }

        .form-loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .success-animation {
            animation: slideUp 0.5s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Loading animation */
        .btn-loading {
            position: relative;
            color: transparent;
        }

        .btn-loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            top: 50%;
            left: 50%;
            margin-left: -8px;
            margin-top: -8px;
            border: 2px solid #ffffff;
            border-radius: 50%;
            border-right-color: transparent;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
    </style>
</head>
<body>

<!-- NAV -->
<header class="nav">
    <div class="nav-inner">
        <div class="brand">
            <span class="brand-badge">⚡</span>
            <span>Airunner</span>
        </div>
        <nav class="nav-links">
            <a href="#features">Features</a>
            <a href="#how-it-works">How It Works</a>
            <a href="#pricing">Pricing</a>
            <a href="/lead-management/public/app">Dashboard</a>
        </nav>
        <a class="cta" href="/lead-management/public/app">Launch App</a>
    </div>
</header>

<!-- HERO -->
<section class="hero">
    <div class="hero-inner">
        <div>
            <span class="hero-badge">🚀 AI-Powered Lead Management</span>
            <h1>Stop Losing Leads. Start Converting with AI.</h1>
            <p>Capture, score, and engage leads automatically while you focus on closing deals. 40% faster response times, 25% higher conversion rates.</p>

            <div class="hero-ctas">
                <a class="btn btn-primary" href="/lead-management/public/app">Start Free Trial</a>
                <a class="btn btn-ghost" href="#demo">Watch Demo (2 min)</a>
            </div>

            <div style="margin-top: 2rem; display: flex; gap: 2rem; color: #cbd5e1; font-size: 0.9rem;">
                <div>✅ No credit card required</div>
                <div>✅ Setup in 5 minutes</div>
                <div>✅ Free 14-day trial</div>
            </div>
        </div>
        <div class="shot" aria-hidden="true">
            <div class="dashboard-preview">
                <div class="dashboard-header">
                    <div class="dashboard-tab active">Leads</div>
                    <div class="dashboard-tab">Analytics</div>
                    <div class="dashboard-tab">AI Tools</div>
                </div>
                <div class="dashboard-content">
                    <div class="metric-card">
                        <div class="metric-title">New Leads Today</div>
                        <div class="metric-value">24</div>
                        <div class="metric-change positive">↑ 18.4%</div>
                        <div class="chart-placeholder"></div>
                    </div>
                    <div class="metric-card">
                        <div class="metric-title">Conversion Rate</div>
                        <div class="metric-value">12.8%</div>
                        <div class="metric-change positive">↑ 3.2%</div>
                        <div class="chart-placeholder"></div>
                    </div>
                    <div class="metric-card">
                        <div class="metric-title">Response Time</div>
                        <div class="metric-value">1.2h</div>
                        <div class="metric-change positive">↑ 25.3%</div>
                        <div class="chart-placeholder"></div>
                    </div>
                    <div class="metric-card">
                        <div class="metric-title">AI Responses</div>
                        <div class="metric-value">156</div>
                        <div class="metric-change positive">↑ 42.1%</div>
                        <div class="chart-placeholder"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- TRUST BADGES -->
<section class="trust" id="trust">
    <div class="trust-inner">
        <div class="kpi"><b>2,500+</b><small>Businesses Trust Us</small></div>
        <div class="kpi"><b>98%</b><small>Uptime Guarantee</small></div>
        <div class="kpi"><b>4.9/5</b><small>Customer Rating</small></div>
    </div>
</section>

<!-- FEATURES -->
<section class="section" id="features">
    <div class="section-inner">
        <h2>Everything You Need to Convert More Leads</h2>
        <p class="sub">From capture to conversion - automate your entire lead management process with AI-powered intelligence.</p>

        <div class="grid">
            <article class="card">
                <div class="chip">🤖</div>
                <h3>AI Lead Scoring</h3>
                <p>Automatically prioritize leads based on behavior, engagement, and profile data. Focus on what matters most.</p>
            </article>

            <article class="card">
                <div class="chip">📧</div>
                <h3>Instant Response AI</h3>
                <p>Respond to leads in seconds, not hours. Personalized email generation that sounds human.</p>
            </article>

            <article class="card">
                <div class="chip">📊</div>
                <h3>Real-time Analytics</h3>
                <p>Track lead performance, conversion rates, and campaign effectiveness with beautiful dashboards.</p>
            </article>

            <article class="card">
                <div class="chip">🔗</div>
                <h3>Smart Forms</h3>
                <p>Capture leads anywhere with customizable, embeddable forms that adapt to your brand.</p>
            </article>

            <article class="card">
                <div class="chip">⚡</div>
                <h3>Instant Alerts</h3>
                <p>Get real-time notifications for high-priority leads. Never miss a hot opportunity again.</p>
            </article>

            <article class="card">
                <div class="chip">🔄</div>
                <h3>Workflow Automation</h3>
                <p>Automate follow-ups, assignments, and lead nurturing. Your sales team will thank you.</p>
            </article>
        </div>
    </div>
</section>

<!-- HOW IT WORKS -->
<section class="section" id="how-it-works" style="background: #0e1530;">
    <div class="section-inner">
        <h2 style="text-align: center;">How Airunner Works</h2>
        <p class="sub" style="text-align: center; max-width: 800px; margin: 0 auto 3rem;">Get from zero to converting in just 3 simple steps</p>

        <div class="grid" style="grid-template-columns: 1fr; gap: 2rem;">
            <div style="display: grid; grid-template-columns: 1fr; gap: 2rem;">
                <!-- Step 1 -->
                <div style="display: flex; gap: 2rem; align-items: start;">
                    <div style="background: linear-gradient(135deg, #7c3aed, #6366f1); color: white; width: 50px; height: 50px; border-radius: 12px; display: grid; place-items: center; font-weight: 800; font-size: 1.2rem; flex-shrink: 0;">1</div>
                    <div>
                        <h3 style="color: white; margin-bottom: 0.5rem;">Embed Your Form</h3>
                        <p style="color: #cbd5e1; margin: 0;">Copy and paste one line of code to add smart lead capture forms to your website, landing pages, or ads.</p>
                    </div>
                </div>

                <!-- Step 2 -->
                <div style="display: flex; gap: 2rem; align-items: start;">
                    <div style="background: linear-gradient(135deg, #f97316, #eab308); color: white; width: 50px; height: 50px; border-radius: 12px; display: grid; place-items: center; font-weight: 800; font-size: 1.2rem; flex-shrink: 0;">2</div>
                    <div>
                        <h3 style="color: white; margin-bottom: 0.5rem;">AI Takes Over</h3>
                        <p style="color: #cbd5e1; margin: 0;">Our AI instantly scores leads, generates personalized responses, and routes them to the right team member.</p>
                    </div>
                </div>

                <!-- Step 3 -->
                <div style="display: flex; gap: 2rem; align-items: start;">
                    <div style="background: linear-gradient(135deg, #10b981, #14b8a6); color: white; width: 50px; height: 50px; border-radius: 12px; display: grid; place-items: center; font-weight: 800; font-size: 1.2rem; flex-shrink: 0;">3</div>
                    <div>
                        <h3 style="color: white; margin-bottom: 0.5rem;">Watch Conversions Grow</h3>
                        <p style="color: #cbd5e1; margin: 0;">Track performance, optimize your approach, and close more deals with data-driven insights.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- LEAD CAPTURE FORM -->
<section class="cta-band" id="get-started">
    <div class="cta-inner">
        <div>
            <h3>Ready to Transform Your Lead Management?</h3>
            <p class="muted">Join 2,500+ businesses converting more leads with AI. Start your free 14-day trial.</p>
        </div>
        <div class="lead-form" style="background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2);">
            <form id="leadForm">
                <div id="discountContainer"></div>
                
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1rem;">
                    <div class="form-group">
                        <label for="name">Full Name *</label>
                        <input type="text" id="name" name="name" class="form-control" required placeholder="Enter your name">
                    </div>
                    <div class="form-group">
                        <label for="email">Work Email *</label>
                        <input type="email" id="email" name="email" class="form-control" required placeholder="your@company.com">
                    </div>
                </div>
                <div class="form-group">
                    <label for="company">Company Name</label>
                    <input type="text" id="company" name="company" class="form-control" placeholder="Where do you work?">
                </div>
                <button type="submit" class="btn btn-primary" style="width: 100%; margin-top: 1rem; background: linear-gradient(135deg, #ffb703, #f97316);">
                    Start My Free Trial
                </button>
                <div style="text-align: center; margin-top: 1rem; color: rgba(255,255,255,0.7); font-size: 0.9rem;">
                    No credit card required • 14-day free trial • Setup in 5 minutes
                </div>
            </form>
            <div id="formMessage" class="form-message"></div>
        </div>
    </div>
</section>

<!-- FOOTER -->
<footer id="help">
    <div class="foot-inner">
        <div>
            <div class="brand" style="margin-bottom:8px">
                <span class="brand-badge">✨</span><span>Airunner</span>
            </div>
            <div class="muted">AI-powered lead management for modern teams. Convert more, work less.</div>
        </div>
        <div class="muted" style="display:grid; gap:6px">
            <span>© 2024 Airunner. All rights reserved.</span>
            <span>Convert more leads with AI intelligence.</span>
        </div>
    </div>
</footer>

<script>
// Enhanced Lead Capture Form with Email & Database Storage
document.addEventListener('DOMContentLoaded', function() {
    // Check for existing discount
    checkExistingDiscount();
    
    const leadForm = document.getElementById('leadForm');
    if (leadForm) {
        leadForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.textContent;
            const messageDiv = document.getElementById('formMessage');
            
            // Validate form
            if (!validateForm()) {
                return;
            }
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.textContent = '';
            submitBtn.classList.add('btn-loading');
            messageDiv.style.display = 'none';
            
            // Add loading class to form
            this.classList.add('form-loading');
            
            try {
                const formData = new FormData(this);
                
                // Add discount if available
                if (sessionStorage.getItem('airunner_discount')) {
                    formData.append('discount', '30percent');
                }
                
                const response = await fetch('/lead-management/public/landing/capture', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    // Success state - show enhanced success message
                    showEnhancedSuccess(result.message, result.data);
                    
                    // Reset form
                    this.reset();
                    
                    // Track conversion
                    trackConversion(result.data);
                    
                } else {
                    // Error state
                    showFormError(result.message);
                }
            } catch (error) {
                console.error('Form submission error:', error);
                showFormError('Network error. Please check your connection and try again.');
            } finally {
                submitBtn.disabled = false;
                submitBtn.textContent = originalText;
                submitBtn.classList.remove('btn-loading');
                leadForm.classList.remove('form-loading');
            }
        });
    }
    
    // Enhanced exit-intent popup
    initializeExitIntent();
});

function validateForm() {
    const name = document.getElementById('name').value.trim();
    const email = document.getElementById('email').value.trim();
    const messageDiv = document.getElementById('formMessage');
    
    if (!name) {
        showFormError('Please enter your full name.');
        return false;
    }
    
    if (!email) {
        showFormError('Please enter your email address.');
        return false;
    }
    
    if (!isValidEmail(email)) {
        showFormError('Please enter a valid email address.');
        return false;
    }
    
    return true;
}

function showFormError(message) {
    const messageDiv = document.getElementById('formMessage');
    messageDiv.textContent = message;
    messageDiv.className = 'form-message error';
    messageDiv.style.display = 'block';
    messageDiv.scrollIntoView({ behavior: 'smooth', block: 'center' });
}

function checkExistingDiscount() {
    if (sessionStorage.getItem('airunner_discount')) {
        showDiscountBadge();
    }
}

function showDiscountBadge() {
    const discountContainer = document.getElementById('discountContainer');
    if (discountContainer) {
        discountContainer.innerHTML = `
            <div style="background: linear-gradient(135deg, #dcfce7, #bbf7d0); border: 2px solid #22c55e; padding: 1rem; border-radius: 8px; margin-bottom: 1rem; text-align: center;">
                <strong style="color: #166534; font-size: 1.1rem;">🎉 30% Discount Applied!</strong>
                <div style="font-size: 0.9rem; color: #166534; margin-top: 0.25rem;">
                    Your first 3 months will be 30% off
                </div>
            </div>
        `;
    }
}

function showEnhancedSuccess(message, data) {
    const formSection = document.getElementById('get-started');
    if (!formSection) return;
    
    const successDiv = document.createElement('div');
    successDiv.className = 'success-animation';
    successDiv.innerHTML = `
        <div style="text-align: center; padding: 3rem 2rem; background: linear-gradient(135deg, #dcfce7, #bbf7d0); border: 2px solid #22c55e; border-radius: 16px; margin: 2rem 0;">
            <div class="success-checkmark">
                <div style="font-size: 4rem; margin-bottom: 1rem;">🎉</div>
            </div>
            <h3 style="color: #166534; margin-bottom: 1rem; font-size: 1.5rem;">Welcome to Airunner!</h3>
            <p style="color: #166534; margin-bottom: 1.5rem; font-size: 1.1rem;">${message}</p>
            <div style="background: white; padding: 1.5rem; border-radius: 12px; margin: 1.5rem 0;">
                <h4 style="color: #166534; margin-bottom: 1rem;">What happens next:</h4>
                <div style="display: grid; gap: 0.5rem; text-align: left;">
                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                        <span style="color: #22c55e;">✓</span>
                        <span>Check your email for login details</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                        <span style="color: #22c55e;">✓</span>
                        <span>Set up your first AI-powered form</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 0.5rem;">
                        <span style="color: #22c55e;">✓</span>
                        <span>Start capturing leads in minutes</span>
                    </div>
                </div>
            </div>
            <a href="/lead-management/public/app" class="btn btn-primary" style="background: linear-gradient(135deg, #16a34a, #22c55e); padding: 0.75rem 2rem; font-size: 1.1rem;">
                Launch Your Dashboard ›
            </a>
            <div style="margin-top: 1rem; color: #166534; font-size: 0.9rem;">
                Redirecting automatically in <span id="countdown">10</span> seconds...
            </div>
        </div>
    `;
    
    // Replace form with success message
    const formContainer = formSection.querySelector('.lead-form');
    if (formContainer) {
        formContainer.style.display = 'none';
        formContainer.parentNode.insertBefore(successDiv, formContainer);
    }
    
    // Start countdown for auto-redirect
    startCountdown(10);
    
    // Scroll to success message
    setTimeout(() => {
        successDiv.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }, 300);
}

function startCountdown(seconds) {
    let countdown = seconds;
    const countdownElement = document.getElementById('countdown');
    
    const countdownInterval = setInterval(() => {
        countdown--;
        if (countdownElement) {
            countdownElement.textContent = countdown;
        }
        
        if (countdown <= 0) {
            clearInterval(countdownInterval);
            window.location.href = '/lead-management/public/app';
        }
    }, 1000);
}

function initializeExitIntent() {
    let exitPopupShown = false;

    document.addEventListener('mouseleave', function(e) {
        if (e.clientY < 0 && !exitPopupShown) {
            showExitOffer();
            exitPopupShown = true;
        }
    });

    // Alternative detection for mobile
    document.addEventListener('touchstart', function(e) {
        if (e.touches[0].clientY < 50 && !exitPopupShown) {
            setTimeout(() => showExitOffer(), 1000);
            exitPopupShown = true;
        }
    });
}

function showExitOffer() {
    if (document.getElementById('exit-popup')) return;
    
    const popup = document.createElement('div');
    popup.id = 'exit-popup';
    popup.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 10000; display: flex; align-items: center; justify-content: center; padding: 20px;">
            <div style="background: white; padding: 2rem; border-radius: 12px; max-width: 400px; width: 90%; text-align: center; position: relative;">
                <button onclick="closeExitPopup()" style="position: absolute; top: 10px; right: 10px; background: none; border: none; font-size: 1.5rem; cursor: pointer; color: #666;">×</button>
                
                <div style="margin-bottom: 1rem;">
                    <div style="width: 60px; height: 60px; background: linear-gradient(135deg, #ffb703, #f97316); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 1rem; font-size: 1.5rem;">🎁</div>
                    <h3 style="margin: 0 0 0.5rem; color: #1f2937;">Wait! Special Offer</h3>
                    <p style="color: #6b7280; margin: 0 0 1.5rem;">Get 30% off your first 3 months when you start today.</p>
                </div>
                
                <div style="display: flex; flex-direction: column; gap: 0.5rem;">
                    <button onclick="claimDiscount()" style="background: linear-gradient(135deg, #ffb703, #f97316); color: white; border: none; padding: 0.75rem 1.5rem; border-radius: 8px; font-weight: 600; cursor: pointer; transition: transform 0.2s;">
                        Claim My 30% Discount
                    </button>
                    <button onclick="closeExitPopup()" style="background: transparent; color: #6b7280; border: 1px solid #d1d5db; padding: 0.75rem 1.5rem; border-radius: 8px; cursor: pointer;">
                        No thanks, I'll pay full price
                    </button>
                </div>
                
                <div style="margin-top: 1rem; font-size: 0.8rem; color: #9ca3af;">
                    Limited time offer • No credit card required
                </div>
            </div>
        </div>
    `;
    
    document.body.appendChild(popup);
    document.addEventListener('keydown', handleEscapeKey);
}

function closeExitPopup() {
    const popup = document.getElementById('exit-popup');
    if (popup) {
        popup.remove();
        document.removeEventListener('keydown', handleEscapeKey);
    }
}

function handleEscapeKey(e) {
    if (e.key === 'Escape') closeExitPopup();
}

function claimDiscount() {
    const formSection = document.getElementById('get-started');
    if (formSection) {
        formSection.scrollIntoView({ behavior: 'smooth' });
        
        // Store discount in session
        sessionStorage.setItem('airunner_discount', '30percent');
        
        // Show discount badge
        showDiscountBadge();
    }
    closeExitPopup();
}

function trackConversion(data) {
    // Google Analytics
    if (typeof gtag !== 'undefined') {
        gtag('event', 'conversion', {
            'send_to': 'AW-YOUR_CONVERSION_ID',
            'value': 1.0,
            'currency': 'USD'
        });
    }
    
    // Facebook Pixel
    if (typeof fbq !== 'undefined') {
        fbq('track', 'Lead', {
            value: 1.0,
            currency: 'USD'
        });
    }
    
    console.log('🎯 Lead captured:', data);
}

// Utility function to validate email
function isValidEmail(email) {
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    return emailRegex.test(email);
}

// Add some interactive animations
document.addEventListener('DOMContentLoaded', function() {
    // Animate metric cards on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);

    // Observe metric cards for animation
    document.querySelectorAll('.metric-card').forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(card);
    });
});
</script>

</body>
</html>