<?php
// Expected: $leads = array of leads from LeadsController@index()
// Each lead row likely has: id, first_name, last_name, email, ai_score, status, created_at
$userName = $_SESSION['user_name'] ?? 'there';
?>
<div class="dashboard-container">
    <style>
        .page-header {
            background: rgba(255,255,255,0.9);
            backdrop-filter: blur(18px);
            border-radius: 16px;
            padding: 1.75rem 2rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 8px 20px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(255,255,255,0.9);
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
        }
        .page-header-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: var(--sky-800);
        }
        .page-header-subtitle {
            color: var(--sky-700);
            font-size: 0.95rem;
        }
        .page-header-actions .btn-primary {
            padding: 0.7rem 1.3rem;
            background: var(--primary);
            color: #fff;
            border: none;
            border-radius: 999px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition);
        }
        .page-header-actions .btn-primary:hover {
            background: var(--primary-dark);
            transform: translateY(-1px);
            box-shadow: 0 8px 18px rgba(37, 99, 235, 0.35);
        }

        .leads-card {
            background: linear-gradient(135deg, rgba(255,255,255,0.98), rgba(240,249,255,0.98));
            border-radius: 16px;
            padding: 1.75rem;
            box-shadow: 0 8px 24px rgba(15,23,42,0.08);
            border: 1px solid rgba(255,255,255,0.9);
        }
        .leads-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        .leads-header h2 {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--sky-800);
            display: flex;
            align-items: center;
            gap: .5rem;
        }
        .leads-search {
            display: flex;
            gap: 0.5rem;
            align-items: center;
        }
        .leads-search input {
            padding: 0.45rem 0.75rem;
            border-radius: 999px;
            border: 1px solid var(--sky-200);
            background: #fff;
            min-width: 220px;
            font-size: 0.9rem;
        }

        .data-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.9rem;
            margin-top: 0.5rem;
        }
        .data-table thead {
            background: var(--sky-50);
        }
        .data-table th,
        .data-table td {
            padding: 0.65rem 0.75rem;
            text-align: left;
        }
        .data-table th {
            font-size: 0.8rem;
            letter-spacing: .06em;
            text-transform: uppercase;
            color: var(--sky-700);
            border-bottom: 1px solid var(--sky-200);
        }
        .data-table tbody tr {
            background: rgba(255,255,255,0.9);
            border-bottom: 1px solid var(--sky-100);
            transition: var(--transition);
        }
        .data-table tbody tr:hover {
            background: var(--sky-50);
        }
        .badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 70px;
            padding: 0.15rem 0.6rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        .badge-hot {
            background: rgba(239, 68, 68, 0.08);
            color: var(--danger);
        }
        .badge-warm {
            background: rgba(245, 158, 11, 0.08);
            color: var(--warning);
        }
        .badge-cold {
            background: rgba(148, 163, 184, 0.15);
            color: var(--gray-700);
        }
        .status-pill {
            padding: 0.15rem 0.6rem;
            border-radius: 999px;
            font-size: 0.75rem;
            font-weight: 600;
            background: rgba(34,197,94,0.08);
            color: #16a34a;
        }
        .status-pill-closed {
            background: rgba(15, 23, 42, 0.06);
            color: #0f172a;
        }
        .status-pill-new {
            background: rgba(59,130,246,0.1);
            color: #1d4ed8;
        }
        .table-actions {
            display: flex;
            gap: 0.35rem;
        }
        .btn-link {
            border: none;
            background: transparent;
            color: var(--primary);
            font-size: 0.8rem;
            cursor: pointer;
            text-decoration: none;
        }
        .btn-link-danger {
            color: var(--danger);
        }
        .empty-state {
            text-align: center;
            padding: 2rem;
            color: var(--sky-700);
            font-size: 0.95rem;
        }
        @media (max-width: 768px) {
            .page-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .leads-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .data-table {
                display: block;
                overflow-x: auto;
            }
        }
    </style>

    <header class="page-header">
        <div>
            <div class="page-header-title">Leads</div>
            <div class="page-header-subtitle">
                Manage all leads captured from your forms and imports.
            </div>
        </div>
        <div class="page-header-actions">
            <button class="btn-primary" type="button"
                    onclick="window.location.href='/lead-management/public/app/leads/create'">
                <i class="fas fa-user-plus"></i> New Lead
            </button>
        </div>
    </header>

    <section class="leads-card">
        <div class="leads-header">
            <h2><i class="fas fa-users"></i> All Leads</h2>
            <div class="leads-search">
                <input type="text" placeholder="Search (client-side only demo)" 
                       oninput="filterLeads(this.value)">
            </div>
        </div>

        <?php if (empty($leads)): ?>
            <div class="empty-state">
                No leads yet. Create a lead manually or publish a form to start capturing.
            </div>
        <?php else: ?>
            <table class="data-table" id="leads-table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Score</th>
                        <th>Status</th>
                        <th>Created</th>
                        <th style="text-align:right;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($leads as $lead): ?>
                        <?php
                            $id        = $lead['id'] ?? null;
                            $fullName  = $lead['full_name']
                                ?? trim(($lead['first_name'] ?? '') . ' ' . ($lead['last_name'] ?? ''));
                            $email     = $lead['email'] ?? '';
                            $score     = isset($lead['ai_score']) ? (int)$lead['ai_score'] : ($lead['score'] ?? null);
                            $status    = strtolower($lead['status'] ?? 'new');
                            $createdAt = $lead['created_at'] ?? '';
                            
                            if ($score !== null) {
                                if ($score >= 80) {
                                    $scoreClass = 'badge-hot';
                                    $scoreLabel = 'Hot ' . $score;
                                } elseif ($score >= 50) {
                                    $scoreClass = 'badge-warm';
                                    $scoreLabel = 'Warm ' . $score;
                                } else {
                                    $scoreClass = 'badge-cold';
                                    $scoreLabel = 'Cold ' . $score;
                                }
                            } else {
                                $scoreClass = 'badge-cold';
                                $scoreLabel = 'Not scored';
                            }

                            $statusClass = 'status-pill';
                            if ($status === 'new') {
                                $statusClass = 'status-pill status-pill-new';
                            } elseif (in_array($status, ['closed', 'lost'])) {
                                $statusClass = 'status-pill status-pill-closed';
                            }
                        ?>
                        <tr>
                            <td><?= htmlspecialchars($fullName ?: 'Lead #'.$id) ?></td>
                            <td><?= htmlspecialchars($email ?: '—') ?></td>
                            <td>
                                <span class="badge <?= $scoreClass ?>">
                                    <?= htmlspecialchars($scoreLabel) ?>
                                </span>
                            </td>
                            <td>
                                <span class="<?= $statusClass ?>">
                                    <?= htmlspecialchars(ucfirst($status)) ?>
                                </span>
                            </td>
                            <td><?= htmlspecialchars($createdAt) ?></td>
                            <td style="text-align:right;">
                                <div class="table-actions">
                                    <?php if ($id): ?>
                                        <button type="button" class="btn-link"
                                                onclick="window.location.href='/lead-management/public/app/leads/<?= (int)$id ?>/edit'">
                                            Edit
                                        </button>
                                        <button type="button" class="btn-link btn-link-danger"
                                                onclick="if(confirm('Delete this lead?')){ window.location.href='/lead-management/public/app/leads/<?= (int)$id ?>/delete'; }">
                                            Delete
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </section>
</div>

<script>
    function filterLeads(q) {
        q = q.toLowerCase();
        const rows = document.querySelectorAll('#leads-table tbody tr');
        rows.forEach(row => {
            const text = row.innerText.toLowerCase();
            row.style.display = text.includes(q) ? '' : 'none';
        });
    }
</script>
