<?php include __DIR__ . '/../partials/header.php'; ?>

<div class="py-6">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="md:flex md:items-center md:justify-between">
            <div class="flex-1 min-w-0">
                <h2 class="text-2xl font-bold leading-7 text-gray-900 sm:text-3xl sm:truncate">
                    Form Analytics
                </h2>
                <p class="mt-1 text-sm text-gray-500">
                    Performance insights for: <?= htmlspecialchars($form['name']) ?>
                </p>
            </div>
            <div class="mt-4 flex space-x-3 md:mt-0 md:ml-4">
                <a href="/lead-management/public/app/forms/<?= $form['id'] ?>/submissions" 
                   class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    <svg class="-ml-1 mr-2 h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                    Submissions
                </a>
                <a href="/lead-management/public/app/forms/<?= $form['id'] ?>/edit" 
                   class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Edit Form
                </a>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="mt-6 grid grid-cols-1 gap-5 sm:grid-cols-2 lg:grid-cols-4">
            <!-- Total Submissions -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Total Submissions</dt>
                                <dd class="text-lg font-medium text-gray-900"><?= $analytics['total_submissions'] ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Days -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-6 w-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Active Days</dt>
                                <dd class="text-lg font-medium text-gray-900"><?= $analytics['active_days'] ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Avg. AI Score -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-6 w-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Avg. AI Score</dt>
                                <dd class="text-lg font-medium text-gray-900">
                                    <?= $analytics['avg_ai_score'] ? round($analytics['avg_ai_score'], 1) : 'N/A' ?>
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Conversion Rate -->
            <div class="bg-white overflow-hidden shadow rounded-lg">
                <div class="p-5">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg class="h-6 w-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <div class="ml-5 w-0 flex-1">
                            <dl>
                                <dt class="text-sm font-medium text-gray-500 truncate">Conversion Rate</dt>
                                <dd class="text-lg font-medium text-gray-900">
                                    <?= $conversion['total_leads'] > 0 ? 
                                        round(($conversion['converted_leads'] / $conversion['total_leads']) * 100, 1) : 0 ?>%
                                </dd>
                            </dl>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="mt-8 grid grid-cols-1 gap-6 lg:grid-cols-2">
            <!-- Submission Trends -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Submission Trends (Last 30 Days)</h3>
                <div class="h-64">
                    <!-- Simple bar chart using Tailwind -->
                    <div class="flex items-end justify-between h-48 space-x-1">
                        <?php foreach (array_slice($trends, -14) as $trend): ?>
                        <div class="flex flex-col items-center flex-1">
                            <div class="text-xs text-gray-500 mb-1"><?= date('M j', strtotime($trend['date'])) ?></div>
                            <div class="w-full bg-blue-200 rounded-t hover:bg-blue-300 transition-colors" 
                                 style="height: <?= min(100, ($trend['submissions'] / max(array_column($trends, 'submissions'))) * 100) ?>%"
                                 title="<?= $trend['submissions'] ?> submissions">
                            </div>
                            <div class="text-xs text-gray-700 mt-1"><?= $trend['submissions'] ?></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Lead Conversion -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Lead Conversion</h3>
                <div class="h-64 flex items-center justify-center">
                    <div class="text-center">
                        <div class="relative inline-block">
                            <svg class="w-32 h-32">
                                <circle class="text-gray-200" stroke-width="10" stroke="currentColor" fill="transparent" r="56" cx="64" cy="64"/>
                                <circle class="text-green-500" stroke-width="10" stroke-dasharray="352" 
                                        stroke-dashoffset="<?= 352 - (($conversion['converted_leads'] / max(1, $conversion['total_leads'])) * 352) ?>" 
                                        stroke-linecap="round" stroke="currentColor" fill="transparent" r="56" cx="64" cy="64" 
                                        transform="rotate(-90 64 64)"/>
                            </svg>
                            <div class="absolute inset-0 flex items-center justify-center">
                                <span class="text-2xl font-bold text-gray-900">
                                    <?= $conversion['total_leads'] > 0 ? 
                                        round(($conversion['converted_leads'] / $conversion['total_leads']) * 100, 1) : 0 ?>%
                                </span>
                            </div>
                        </div>
                        <div class="mt-4 grid grid-cols-2 gap-4 text-sm">
                            <div class="text-center">
                                <div class="font-semibold text-gray-900"><?= $conversion['total_leads'] ?></div>
                                <div class="text-gray-500">Total Leads</div>
                            </div>
                            <div class="text-center">
                                <div class="font-semibold text-green-600"><?= $conversion['converted_leads'] ?></div>
                                <div class="text-gray-500">Converted</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Metrics -->
        <div class="mt-8 bg-white shadow rounded-lg">
            <div class="px-4 py-5 sm:px-6 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Form Performance</h3>
            </div>
            <div class="p-6">
                <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">First Submission</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <?= $analytics['first_submission'] ? date('M j, Y g:i A', strtotime($analytics['first_submission'])) : 'Never' ?>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Last Submission</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <?= $analytics['last_submission'] ? date('M j, Y g:i A', strtotime($analytics['last_submission'])) : 'Never' ?>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Average Submissions per Day</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <?= $analytics['active_days'] > 0 ? 
                                round($analytics['total_submissions'] / $analytics['active_days'], 1) : 0 ?>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Form Status</dt>
                        <dd class="mt-1">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                <?= $form['status'] === 'active' ? 'bg-green-100 text-green-800' : 
                                   ($form['status'] === 'draft' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800') ?>">
                                <?= ucfirst($form['status']) ?>
                            </span>
                        </dd>
                    </div>
                </dl>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../partials/footer.php'; ?>