<?php
// $stats, $leads, $taskKpis are passed from DashboardController

$stats     = $stats ?? [];
$leads     = $leads ?? [];
$taskKpis  = $taskKpis ?? [];

// Lead stats
$totalLeads      = (int)($stats['total_leads'] ?? 0);
$totalForms      = (int)($stats['total_forms'] ?? 0);
$leadsToday      = (int)($stats['leads_today'] ?? 0);
$highScoreLeads  = (int)($stats['high_score_leads'] ?? 0);

// Task stats
$totalTasks      = (int)($taskKpis['total']        ?? 0);
$tasksNotStarted = (int)($taskKpis['not_started']  ?? 0);
$tasksInProgress = (int)($taskKpis['in_progress']  ?? 0);
$tasksCompleted  = (int)($taskKpis['completed']    ?? 0);
$tasksCancelled  = (int)($taskKpis['cancelled']    ?? 0);

$userName        = $_SESSION['user_name'] ?? 'there';
?>
<div class="dashboard-container">
    <!-- Header -->
    <header class="dashboard-header">
        <div class="header-content">
            <div class="welcome-section">
                <div class="header-breadcrumb">
                    <button
                        type="button"
                        class="btn-ghost-back"
                        onclick="window.location.href='/lead-management/public/'">
                        ← Back to Home
                    </button>
                </div>
                <h1>Good Morning, <?= htmlspecialchars($userName) ?>!</h1>
                <p>Here’s your lead & workspace overview for today.</p>
            </div>
            <div class="header-actions">
                <button class="btn-primary" type="button"
                    onclick="window.location.href='/lead-management/public/app/forms/create'">
                    <i class="fas fa-plus"></i> New Form
                </button>
            </div>
        </div>

        <!-- Quick Stats: Leads & Forms -->
        <div class="quick-stats">
            <div class="stat-card">
                <div class="stat-number"><?= $totalLeads ?></div>
                <div class="stat-label">Total Leads</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $totalForms ?></div>
                <div class="stat-label">Active Forms</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $leadsToday ?></div>
                <div class="stat-label">Leads Today</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $highScoreLeads ?></div>
                <div class="stat-label">High Priority</div>
            </div>
        </div>

        <!-- Quick Stats: Tasks (KPIs) -->
        <div class="quick-stats quick-stats-secondary">
            <div class="stat-card">
                <div class="stat-number"><?= $totalTasks ?></div>
                <div class="stat-label">Total Tasks</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $tasksNotStarted ?></div>
                <div class="stat-label">Not Started</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $tasksInProgress ?></div>
                <div class="stat-label">In Progress</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $tasksCompleted ?></div>
                <div class="stat-label">Completed</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $tasksCancelled ?></div>
                <div class="stat-label">Cancelled</div>
            </div>
        </div>
    </header>

    <!-- Dashboard Grid -->
    <div class="dashboard-grid">
        <!-- Recent Leads (left side, top) -->
        <section class="tasks-section recent-section">
            <div class="section-header">
                <h2><i class="fas fa-list-check"></i> Recent Leads</h2>
            </div>

            <?php if (empty($leads)): ?>
                <p>No leads yet. Create a form to start capturing leads!</p>
            <?php else: ?>
                <div class="deadlines-list">
                    <?php foreach ($leads as $lead): ?>
                        <div class="deadline-item">
                            <div class="deadline-icon">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="deadline-content">
                                <div class="deadline-title">
                                    <?= htmlspecialchars($lead['full_name'] ?? ($lead['first_name'] ?? 'Lead')) ?>
                                </div>
                                <div class="deadline-date">
                                    <i class="fas fa-envelope"></i>
                                    <?= htmlspecialchars($lead['email'] ?? 'No email') ?>
                                </div>
                                <div class="deadline-date">
                                    <i class="fas fa-clock"></i>
                                    <?= htmlspecialchars($lead['created_at'] ?? '') ?>
                                </div>
                            </div>
                            <?php
                            $score = isset($lead['score']) ? (int)$lead['score'] : null;
                            if ($score !== null) {
                                if ($score >= 80) {
                                    $badgeClass = 'urgency-high';
                                    $label = 'Hot (' . $score . ')';
                                } elseif ($score >= 50) {
                                    $badgeClass = 'urgency-medium';
                                    $label = 'Warm (' . $score . ')';
                                } else {
                                    $badgeClass = 'urgency-low';
                                    $label = 'Cold (' . $score . ')';
                                }
                            } else {
                                $badgeClass = 'urgency-low';
                                $label = 'Not scored';
                            }
                            ?>
                            <div class="deadline-urgency <?= $badgeClass ?>">
                                <?= htmlspecialchars($label) ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </section>

        <!-- Quick Actions (top right) -->
        <section class="quick-actions-section">
            <div class="section-header">
                <h2><i class="fas fa-bolt"></i> Quick Actions</h2>
            </div>
            <div class="quick-actions-grid">
                <div class="action-card" onclick="window.location.href='/lead-management/public/app/forms/create'">
                    <div class="action-icon">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <div class="action-title">Create Form</div>
                    <div class="action-desc">Launch a new lead capture form</div>
                </div>
                <div class="action-card" onclick="window.location.href='/lead-management/public/app/leads'">
                    <div class="action-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="action-title">View Leads</div>
                    <div class="action-desc">Browse all captured leads</div>
                </div>
                <div class="action-card" onclick="window.location.href='/lead-management/public/app/tasks'">
                    <div class="action-icon">
                        <i class="fas fa-list-check"></i>
                    </div>
                    <div class="action-title">View Tasks</div>
                    <div class="action-desc">Review and manage your tasks</div>
                </div>
                <div class="action-card" onclick="window.location.href='/lead-management/public/app/weekly-reports'">
                    <div class="action-icon">
                        <i class="fas fa-calendar-week"></i>
                    </div>
                    <div class="action-title">Weekly Report</div>
                    <div class="action-desc">Submit this week’s accomplishments</div>
                </div>
            </div>
        </section>

        <!-- Performance Overview (middle left) -->
        <section class="reports-section">
            <div class="section-header">
                <h2><i class="fas fa-chart-line"></i> Performance Overview</h2>
            </div>
            <p>
                Conversion rates, traffic sources and AI scoring trends will appear here as data accumulates.
                For now, you can focus on getting your first leads through forms and imports.
            </p>
        </section>

        <!-- Weekly Progress (middle right) -->
        <section class="progress-section">
            <div class="section-header">
                <h2><i class="fas fa-chart-bar"></i> Weekly Progress</h2>
            </div>
            <div class="progress-list">
                <div class="progress-item">
                    <div class="progress-header">
                        <div class="progress-label">Leads captured this week</div>
                        <div class="progress-value">
                            <?= $totalLeads > 0 ? '✓' : '0' ?>
                        </div>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?= $totalLeads > 0 ? '60%' : '10%' ?>"></div>
                    </div>
                </div>
                <div class="progress-item">
                    <div class="progress-header">
                        <div class="progress-label">Forms live</div>
                        <div class="progress-value"><?= $totalForms ?></div>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?= $totalForms > 0 ? '70%' : '20%' ?>"></div>
                    </div>
                </div>
                <div class="progress-item">
                    <div class="progress-header">
                        <div class="progress-label">High-priority leads</div>
                        <div class="progress-value"><?= $highScoreLeads ?></div>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: <?= $highScoreLeads > 0 ? '80%' : '15%' ?>"></div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Next Steps (full width bottom) -->
        <section class="deadlines-section">
            <div class="section-header">
                <h2><i class="fas fa-clock"></i> Next Steps</h2>
            </div>
            <div class="deadlines-list">
                <div class="deadline-item">
                    <div class="deadline-icon">
                        <i class="fas fa-key"></i>
                    </div>
                    <div class="deadline-content">
                        <div class="deadline-title">Add AI Provider Key</div>
                        <div class="deadline-date">
                            <i class="fas fa-calendar"></i> Recommended: Today
                        </div>
                    </div>
                    <div class="deadline-urgency urgency-high">High</div>
                </div>
                <div class="deadline-item">
                    <div class="deadline-icon">
                        <i class="fas fa-clipboard-list"></i>
                    </div>
                    <div class="deadline-content">
                        <div class="deadline-title">Publish First Form</div>
                        <div class="deadline-date">
                            <i class="fas fa-calendar"></i> Recommended: This week
                        </div>
                    </div>
                    <div class="deadline-urgency urgency-medium">Medium</div>
                </div>
                <div class="deadline-item">
                    <div class="deadline-icon">
                        <i class="fas fa-envelope-open-text"></i>
                    </div>
                    <div class="deadline-content">
                        <div class="deadline-title">Set Welcome Email</div>
                        <div class="deadline-date">
                            <i class="fas fa-calendar"></i> After first leads arrive
                        </div>
                    </div>
                    <div class="deadline-urgency urgency-low">Low</div>
                </div>
            </div>
        </section>
    </div>
</div>

<style>
    .header-breadcrumb {
        margin-bottom: 0.4rem;
    }

    .btn-ghost-back {
        border-radius: 999px;
        padding: 0.25rem 0.9rem;
        font-size: 0.8rem;
        border: 1px solid rgba(148, 163, 184, 0.6);
        background: rgba(255, 255, 255, 0.85);
        color: #2563eb;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
    }

    .btn-ghost-back:hover {
        background: rgba(219, 234, 254, 0.9);
    }
</style>