<?php
// $pageTitle is set in View->render() call
$userName  = $_SESSION['user_name'] ?? 'User';
$userEmail = $_SESSION['user_email'] ?? '';
$initials  = strtoupper(mb_substr($userName, 0, 1));
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($pageTitle ?? 'Dashboard') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Icons + Dashboard CSS -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
        integrity="sha512-pIVpG8GkZZgwyU0YJIUKGwEuITdSb9VjA36TObgGJE0E7E5Wdl0iRS0LlwM651c01qmPvvrL1jAUx0xN5fLwAw=="
        crossorigin="anonymous"
        referrerpolicy="no-referrer">
    <link rel="stylesheet" href="/lead-management/public/assets/css/dashboard.css">
</head>

<body>
    <!-- Sidebar (global for all app pages) -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="logo">
                <span class="logo-icon"><i class="fas fa-cloud-sun"></i></span>
                <span class="logo-text">Airunner</span>
            </div>
            <button class="toggle-sidebar" type="button">
                <i class="fas fa-chevron-left"></i>
            </button>
        </div>

        <nav class="sidebar-nav">
            <div class="nav-section">
                <div class="nav-title">Main</div>

                <a href="/lead-management/public/app"
                    class="nav-item <?= ($_SERVER['REQUEST_URI'] === '/lead-management/public/app') ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-home"></i></div>
                    <span class="nav-text">Dashboard</span>
                </a>

                <a href="/lead-management/public/app/leads"
                    class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/leads') !== false) ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-users"></i></div>
                    <span class="nav-text">Leads</span>
                </a>

                <a href="/lead-management/public/app/tasks"
                    class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/tasks') !== false) ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-tasks"></i></div>
                    <span class="nav-text">Tasks</span>
                </a>

                <a href="/lead-management/public/app/forms"
                    class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/forms') !== false) ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-clipboard-list"></i></div>
                    <span class="nav-text">Forms</span>
                </a>

                <a href="/lead-management/public/app/ai-tools"
                    class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/ai-tools') !== false) ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-robot"></i></div>
                    <span class="nav-text">AI Tools</span>
                </a>
            </div>
            <a href="/lead-management/public/app/weekly-reports"
                class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/weekly-reports') !== false) ? 'active' : '' ?>">
                <div class="nav-icon"><i class="fas fa-calendar-week"></i></div>
                <span class="nav-text">Weekly Reports</span>
            </a>

            <div class="nav-section">
                <div class="nav-title">Workspace</div>

                <a href="/lead-management/public/app/analytics"
                    class="nav-item <?= (strpos($_SERVER['REQUEST_URI'], '/app/analytics') !== false) ? 'active' : '' ?>">
                    <div class="nav-icon"><i class="fas fa-chart-bar"></i></div>
                    <span class="nav-text">Analytics</span>
                </a>
            </div>
        </nav>

        <div class="sidebar-footer">
            <div class="user-profile">
                <div class="user-avatar"><?= htmlspecialchars($initials) ?></div>
                <div>
                    <div style="font-weight: 600;"><?= htmlspecialchars($userName) ?></div>
                    <?php if ($userEmail): ?>
                        <div style="font-size: 0.8rem; color: var(--sky-700);">
                            <?= htmlspecialchars($userEmail) ?>
                        </div>
                    <?php endif; ?>
                    <div style="margin-top: 0.25rem;">
                        <a href="/lead-management/public/logout"
                            style="font-size: 0.8rem; color: var(--danger); text-decoration: none;">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content (page-specific content goes here) -->
    <main class="main-content">
        <?= $content ?>
        <footer class="dashboard-footer">
            <div class="footer-content">
                <div>© <?= date('Y') ?> Airunner. All rights reserved.</div>
                <div>
                    <a href="#" class="footer-link">Privacy Policy</a>
                    <a href="#" class="footer-link">Terms of Service</a>
                    <a href="#" class="footer-link">Contact Us</a>
                </div>
            </div>
        </footer>
    </main>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar toggle
            const toggleButton = document.querySelector('.toggle-sidebar');
            const sidebar = document.querySelector('.sidebar');
            const body = document.body;

            if (toggleButton && sidebar) {
                toggleButton.addEventListener('click', function() {
                    sidebar.classList.toggle('collapsed');
                    body.classList.toggle('sidebar-collapsed');

                    const icon = this.querySelector('i');
                    if (sidebar.classList.contains('collapsed')) {
                        icon.className = 'fas fa-chevron-right';
                    } else {
                        icon.className = 'fas fa-chevron-left';
                    }
                });
            }

            // Progress bars (safe even on pages without them)
            const progressBars = document.querySelectorAll('.progress-fill');

            if (progressBars.length > 0) {
                setTimeout(() => {
                    progressBars.forEach(bar => {
                        const width = bar.style.width;
                        bar.style.width = '0';
                        setTimeout(() => {
                            bar.style.width = width;
                        }, 200);
                    });
                }, 500);
            }
        });
    </script>
</body>

</html>