  <!-- Our Footer (this is the only one that should show) -->
  <footer class="auth-site-footer">
      <div class="auth-footer-wrap">
          <div class="auth-footer-grid">
              <div>
                  <div class="auth-footer-brand">
                      <span class="auth-brand-badge">🧠</span>
                      <span>LeadIntelligence AI</span>
                  </div>
                  <p style="color: rgba(255,255,255,0.7); margin: 0; line-height: 1.5;">
                      Streamline your lead management with AI-powered tools that help you capture, track, and convert leads efficiently.
                  </p>
              </div>

              <div class="auth-footer-col">
                  <h4>Product</h4>
                  <a href="<?= $baseUrl ?? '' ?>/#features">Features</a>
                  <a href="<?= $baseUrl ?? '' ?>/#pricing">Pricing</a>
                  <a href="<?= $baseUrl ?? '' ?>/integrations">Integrations</a>
              </div>

              <div class="auth-footer-col">
                  <h4>Company</h4>
                  <a href="<?= $baseUrl ?? '' ?>/about">About</a>
                  <a href="<?= $baseUrl ?? '' ?>/blog">Blog</a>
                  <a href="<?= $baseUrl ?? '' ?>/careers">Careers</a>
              </div>

              <div class="auth-footer-col">
                  <h4>Support</h4>
                  <a href="<?= $baseUrl ?? '' ?>/docs">Documentation</a>
                  <a href="<?= $baseUrl ?? '' ?>/contact">Contact</a>
                  <a href="<?= $baseUrl ?? '' ?>/status">Status</a>
              </div>
          </div>

          <div class="auth-footer-bottom">
              © 2025 LeadIntelligence AI. All rights reserved.
          </div>
      </div>
  </footer>

  <script>
      // Account type selection
      document.querySelectorAll('.account-type-card').forEach(card => {
          card.addEventListener('click', function() {
              // Remove selected class from all cards
              document.querySelectorAll('.account-type-card').forEach(c => {
                  c.classList.remove('selected');
              });

              // Add selected class to clicked card
              this.classList.add('selected');

              // Update the radio button
              const radio = this.querySelector('.account-type-radio');
              radio.checked = true;

              // Toggle company fields
              const companyField = document.getElementById('company-field');
              const companyRequired = document.getElementById('company-required');
              const companyInput = document.getElementById('company_name');

              if (radio.value === 'company') {
                  companyField.classList.add('active');
                  companyRequired.style.display = 'inline';
                  companyInput.required = true;
              } else {
                  companyField.classList.remove('active');
                  companyRequired.style.display = 'none';
                  companyInput.required = false;
                  companyInput.value = '';
              }
          });
      });

      // Password strength meter
      const passwordInput = document.getElementById('password');
      const strengthFill = document.getElementById('password-strength-bar');
      const strengthText = document.getElementById('password-strength-text');

      if (passwordInput && strengthFill && strengthText) {
          passwordInput.addEventListener('input', function() {
              const password = this.value;
              let strength = 0;

              // Length check
              if (password.length >= 8) strength += 20;
              if (password.length >= 12) strength += 10;

              // Character variety checks
              if (/[a-z]/.test(password)) strength += 20;
              if (/[A-Z]/.test(password)) strength += 20;
              if (/[0-9]/.test(password)) strength += 20;
              if (/[^a-zA-Z0-9]/.test(password)) strength += 10;

              // Cap at 100%
              strength = Math.min(strength, 100);

              // Update visual meter
              strengthFill.style.width = strength + '%';

              // Update colors and text
              if (strength < 40) {
                  strengthFill.className = 'strength-fill strength-weak';
                  strengthText.textContent = 'Password strength: Weak';
              } else if (strength < 70) {
                  strengthFill.className = 'strength-fill strength-medium';
                  strengthText.textContent = 'Password strength: Medium';
              } else {
                  strengthFill.className = 'strength-fill strength-strong';
                  strengthText.textContent = 'Password strength: Strong';
              }
          });
      }

      // Form validation for company field
      const registerForm = document.getElementById('registerForm');
      if (registerForm) {
          registerForm.addEventListener('submit', function(e) {
              const accountType = document.querySelector('input[name="account_type"]:checked')?.value;
              const companyInput = document.getElementById('company_name');

              if (accountType === 'company' && !companyInput.value.trim()) {
                  e.preventDefault();
                  alert('Please enter your company name for business accounts.');
                  companyInput.focus();
              }
          });
      }
  </script>
  </body>

  </html>