<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title><?= $title ?? 'LeadIntelligence AI' ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <style>
    /* =========================================================
       LeadIntelligence AI — Auth Compact Theme
       ========================================================= */

    /* ---- Theme tokens ---- */
    :root{
      --ink:#0f172a; --muted:#48556a; --line:#e6e9ef; --card:#ffffff;
      --bg1:#6e75d7; --bg2:#6570c9; --bg3:#5b6abc;
      --primary:#6366f1; --danger:#ef4444; --success:#10b981;
      --radius:16px; --shadow-lg:0 22px 48px rgba(2,6,23,.16);
    }

    /* ---- Backdrop + base ---- */
    html,body{height:100%; margin:0; padding:0;}
    body{
      color:var(--ink);
      font:15px/1.55 system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial,sans-serif;
      background:linear-gradient(135deg,var(--bg1),var(--bg2) 50%,var(--bg3));
      display: flex;
      flex-direction: column;
    }

    /* ---- Header Styles ---- */
    .site-header{
      position:sticky; top:0; z-index:50;
      background:rgba(255,255,255,.9);
      backdrop-filter:saturate(140%) blur(8px);
      border-bottom:1px solid var(--line);
    }
    .nav{
      max-width:1200px; margin:0 auto;
      display:flex; align-items:center; justify-content:space-between;
      padding:12px 20px;
    }
    .brand{
      display:flex; align-items:center; gap:10px; font-weight:800;
      color: var(--ink); text-decoration: none;
    }
    .brand-badge{
      width:32px; height:32px; border-radius:8px;
      background:linear-gradient(135deg,#a78bfa,#6366f1);
      display:grid; place-items:center; color:white; font-size:16px;
      box-shadow:0 6px 16px rgba(99,102,241,.35)
    }
    .nav-links{
      display:flex; gap:24px; align-items:center;
    }
    .nav-links a{
      color:#334155; font-weight:600; text-decoration:none;
      transition: color 0.2s ease;
    }
    .nav-links a:hover{ color:var(--primary); }
    .nav-cta{ display:flex; align-items:center; gap:16px; }
    .btn{
      display:inline-flex; align-items:center; justify-content:center;
      border-radius:10px; padding:10px 20px; font-weight:700;
      text-decoration: none; transition: all 0.2s ease;
    }
    .btn-plain{ color:#334155; }
    .btn-primary{
      background:linear-gradient(135deg,#7c83f8,#6366f1);
      color:#fff; box-shadow:0 8px 20px rgba(99,102,241,.35);
    }
    .btn-primary:hover{ filter:brightness(.98); transform: translateY(-1px); }

    /* ---- Auth layout ---- */
    .auth-main{
      flex: 1;
      display:flex;
      align-items:center;
      justify-content:center;
      padding:40px 20px;
    }
    .auth-container{ width:100%; max-width:1060px; margin:0 auto; }
    .auth-card{
      background:var(--card);
      border:1px solid var(--line);
      border-radius:var(--radius);
      box-shadow:var(--shadow-lg);
      overflow:hidden;
    }
    .auth-card.login,
    .auth-card.forgot,
    .auth-card.reset{ max-width:520px; margin: 0 auto; }

    .auth-card-header{
      padding:28px 32px;
      border-bottom:1px solid var(--line);
      background:linear-gradient(180deg,#fafbff,#ffffff);
    }
    .auth-title{ margin:0 0 4px; font-size:22px; letter-spacing:.2px; }
    .auth-subtitle{ margin:0; color:var(--muted); }
    .auth-link-primary{ color:var(--primary); font-weight:700; text-decoration: none; }
    .auth-link-primary:hover{ text-decoration: underline; }

    /* ---- Form ---- */
    .auth-form{ padding:28px 32px; }
    .form-group + .form-group{ margin-top:16px; }
    .form-label{ display:block; font-weight:800; margin:0 0 8px; }
    .form-label-required{ color:var(--danger); margin-left:3px; }
    .form-input{
      width:100%; padding:12px;
      border:1px solid #d9dee8; border-radius:12px; background:#fff; outline:none;
      transition:box-shadow .2s, border-color .2s;
      font-size:16px;
    }
    .form-input:focus{ border-color:#b4baf0; box-shadow:0 0 0 3px rgba(99,102,241,.18); }
    .form-hint{ color:#6b7280; font-size:12px; margin-top:6px; }

    /* Register: two-column names */
    .form-row{ display:grid; grid-template-columns:repeat(2, minmax(320px, 1fr)); gap:20px; }
    @media (max-width:900px){ .form-row{ grid-template-columns:1fr; } }

    /* ---- Account-Type cards (Register) ---- */
    .account-type-grid{
      display:grid; grid-template-columns:repeat(2, minmax(320px, 1fr)); gap:18px; margin-top:8px;
    }
    @media (max-width:900px){ .account-type-grid{ grid-template-columns:1fr; } }
    .account-type-card{
      position:relative; padding:20px 20px 20px 60px;
      border:1px solid #d9dee8; border-radius:12px; background:#fff;
      cursor:pointer; display:flex; flex-direction:column; justify-content:center;
      min-height:120px;
      transition:all 0.2s ease;
    }
    .account-type-card:hover {
      border-color:#b4baf0;
    }
    .account-type-card .account-type-icon{
      position:absolute; left:20px; top:50%; transform:translateY(-50%); font-size:24px;
    }
    .account-type-card.selected{ 
      border-color:#6366f1; 
      background:#f8faff;
      box-shadow:0 0 0 3px rgba(99,102,241,.18); 
    }
    .account-type-radio{ position:absolute; opacity:0; pointer-events:none; }
    .account-type-card strong{ display:block; font-size:16px; margin-bottom:4px; }
    .account-type-card small{ color:#6b7280; font-size:14px; }

    /* Company field section (Register) */
    .company-fields{
      border:1px dashed #c7cce0; border-radius:12px; padding:20px; background:#fafbff; margin-top:16px;
    }
    .company-fields:not(.active){ display:none; }

    /* ---- Password strength (Register) ---- */
    .password-strength{ margin-top:8px; }
    .strength-bar{ height:8px; background:#eef2ff; border-radius:999px; overflow:hidden; }
    .strength-fill{ height:100%; width:0%; transition:width .25s ease; border-radius:inherit; }
    .strength-weak{ background:#f43f5e; }
    .strength-medium{ background:#f59e0b; }
    .strength-strong, .strength-very-strong{ background:#10b981; }
    .strength-text{ font-size:12px; color:#475569; margin-top:6px; }

    /* ---- Checkbox ---- */
    .checkbox-group{ display:flex; align-items:flex-start; gap:10px; margin:20px 0; }
    .checkbox-input{ transform:scale(1.1); margin-top:2px; }
    .checkbox-label{ font-size:14px; line-height:1.4; }
    .checkbox-label a{ color:var(--primary); font-weight:700; text-decoration:none; }
    .checkbox-label a:hover{ text-decoration:underline; }

    /* ---- Login options ---- */
    .login-options{ display:flex; align-items:center; justify-content:space-between; gap:12px; margin:16px 0 0; }
    .forgot-password{ color:var(--primary); font-weight:700; text-decoration:none; white-space:nowrap; }
    .forgot-password:hover{ text-decoration:underline; }

    /* ---- Alerts ---- */
    .form-error, .form-success{
      margin:0 32px 20px; padding:12px 16px; border-radius:10px; font-weight:600;
    }
    .form-error{ color:#991b1b; background:#fee2e2; border:1px solid #fecaca; }
    .form-success{ color:#065f46; background:#d1fae5; border:1px solid #a7f3d0; }

    /* ---- Submit + links ---- */
    .auth-button{
      width:100%; padding:14px 16px; border-radius:12px; border:0;
      font-weight:800; color:#fff; background:linear-gradient(135deg,#7c83f8,#6366f1);
      box-shadow:0 10px 24px rgba(99,102,241,.35); cursor:pointer;
      font-size:16px;
      transition:filter 0.2s ease;
    }
    .auth-button:hover{ filter:brightness(.98); }

    .auth-links{ text-align:center; margin-top:20px; padding-top:20px; border-top:1px solid var(--line); }
    .auth-text-muted{ color:#6b7280; font-size:14px; }
    .auth-links a{ color:var(--primary); font-weight:700; text-decoration:none; }
    .auth-links a:hover{ text-decoration:underline; }

    /* ---- Footer Styles ---- */
    .site-footer{
      background: transparent;
      color: rgba(255,255,255,0.8);
      margin-top: auto;
    }
    .footer-wrap{
      max-width:1200px; margin:0 auto; padding:40px 20px;
    }
    .footer-grid{
      display:grid; grid-template-columns:2fr 1fr 1fr 1fr; gap:40px;
    }
    @media (max-width:900px){ .footer-grid{ grid-template-columns:1fr 1fr; gap:30px; } }
    @media (max-width:600px){ .footer-grid{ grid-template-columns:1fr; gap:20px; } }
    .footer-brand{
      display:flex; align-items:center; gap:10px; font-weight:800; margin-bottom:16px;
    }
    .footer-brand .brand-badge{ box-shadow:none; }
    .footer-col h4{
      margin:0 0 16px; color:white; font-weight:700; font-size:16px;
    }
    .footer-col a{
      display:block; color:rgba(255,255,255,0.7); text-decoration:none;
      margin:8px 0; transition: color 0.2s ease;
    }
    .footer-col a:hover{ color:white; }
    .footer-bottom{
      border-top:1px solid rgba(255,255,255,0.2);
      margin-top:40px; padding-top:20px;
      text-align:center; color:rgba(255,255,255,0.7);
      font-size:14px;
    }
  </style>
</head>
<body>
  <!-- Header -->
  <header class="site-header">
    <div class="nav">
      <a class="brand" href="<?= $baseUrl ?? '/' ?>">
        <span class="brand-badge">🧠</span>
        <span>LeadIntelligence AI</span>
      </a>

      <nav class="nav-links">
        <a href="<?= $baseUrl ?? '' ?>/#features">Features</a>
        <a href="<?= $baseUrl ?? '' ?>/#pricing">Pricing</a>
        <a href="<?= $baseUrl ?? '' ?>/#about">About</a>
      </nav>

      <div class="nav-cta">
        <a class="btn btn-plain" href="<?= $baseUrl ?? '' ?>/login">Sign In</a>
        <a class="btn btn-primary" href="<?= $baseUrl ?? '' ?>/register">Get Started Free</a>
      </div>
    </div>
  </header>